#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//On the train to fosdemMod01.fsh   by  totetmatt 
//https://www.shadertoy.com/view/wt3SR4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define cTime floor(iTime) + pow(fract(iTime),.5 + (sin(iTime*10.)*.5+.5)+.1)
mat2 r(float a){ return mat2(cos(a),sin(a),-sin(a),cos(a));}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    uv*=r(iTime*.1+smoothstep(5.9,.1,length(uv)));
    
    uv = abs(uv);
   
    uv*=10.;
    uv*=sin(length(cos(uv)*.5+cTime));
    uv*=r(length(uv*.1-iTime*.1)+iTime*.12);
    vec2 id= floor(uv);
     uv = fract(uv+cTime*.13)-.5;
    float d = 0.;
       
    if(mod(id.x,2.) - mod(id.y,2.) == 0.) {
        d = min(abs(uv.x+uv.y),.1);
    } else {   
        d = min(abs(uv.y-uv.x),.1);
    }
    d = smoothstep(0.2,.09-length(uv+sin(iTime)*.4),d);
    vec3 col;
    if( mod(id.x,2.) - mod(id.y,2.) == 0.) {
        col = mix(vec3(.1),vec3(.9,.3,.2*(1.-d)),vec3(d));
    } else {
        col = mix(vec3(.1),vec3(.2,.3*(1.-d),.9),vec3(d));
    }
       
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

